import Tag from '../Tag';
import { ParseOptions, TagOptions } from '../type';
/**
 * 在pre内部所有元素，应该转换为 plain text，并入 ``` 内部， 保持格式
 */
declare class Pre extends Tag {
    isIndent: boolean;
    constructor(str: string, tagName: string | undefined, options: TagOptions);
    beforeMergeSpace(content: string): string;
    fillPerLine(lineStr: string): string;
    afterMergeSpace(content: string): string;
    parseValidSubTag(subTagStr: string, subTagName: string, options: ParseOptions): [string, any];
    parseOnlyString(subTagStr: string): [string, any];
    slim(content: string): string;
    exec(prevGap?: string, endGap?: string): string;
}
export default Pre;
