import { ParseOptions, TagName, TagOptions, TagProps } from './type';
declare class Tag implements TagProps {
    constructor(str: string, tagName: TagName, { keepSpace, prevTagName, nextTagName, prevTagStr, nextTagStr, parentTag, isFirstSubTag, calcLeading, leadingSpace, layer, noWrap, prevHasEndSpace, prevHasStartSpace, match, indentSpace, language, count, tableColumnCount, noExtraLine, inTable, }?: TagOptions);
    tagName: TagName;
    parentTag: TagName;
    prevTagName: TagName;
    nextTagName: TagName;
    rawStr: string;
    prevTagStr: string;
    nextTagStr: string;
    isFirstSubTag: boolean;
    calcLeading: boolean;
    leadingSpace: string;
    layer: number;
    noWrap: boolean;
    hasEndSpace: boolean;
    hasStartSpace: boolean;
    prevHasEndSpace: boolean;
    prevHasStartSpace: boolean;
    match: string | null;
    indentSpace: string;
    language: string;
    count: number;
    tableColumnCount: number;
    noExtraLine: boolean;
    keepSpace: boolean;
    inTable: boolean;
    attrs: Record<string, string>;
    innerHTML: string;
    /**
     * Detect is a valid tag string
     * @param str
     * @param tagName
     * @returns {boolean}
     */
    __detectStr__(str: string, tagName: TagName): boolean;
    /**
     *
     * @param str
     * @returns {{attr: {}, innerHTML: *}}
     */
    __fetchTagAttrAndInnerHTML__(str: string): {
        attr: Record<string, string>;
        innerHTML: string;
    };
    __onlyLeadingSpace__(str: string): boolean;
    __isEmpty__(str: string): boolean;
    getValidSubTagName(subTag: TagName): TagName;
    beforeParse(): string;
    parseValidSubTag(subTagStr: string, subTagName: string, options: ParseOptions): [string, any];
    parseOnlyString(subTagStr: string, subTagName: TagName, options: ParseOptions): [string, any];
    afterParsed(content: string): string;
    slim(content: string): string;
    beforeMergeSpace(content: string): string;
    mergeSpace(content: string, prevGap: string, endGap: string): string;
    afterMergeSpace(content: string): string;
    beforeReturn(content: string): string;
    exec(prevGap?: string, endGap?: string): string;
}
export default Tag;
