<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use App\Models\User;
use App\Models\Branch;
use Spatie\Permission\Models\Role;

class UserRoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create branches first if they don't exist
        $nairobiBranch = Branch::firstOrCreate([
            'name' => 'Nairobi Main Branch'
        ], [
            'location' => 'Nairobi CBD',
            'description' => 'Main branch located in the heart of Nairobi'
        ]);

        $mombasaBranch = Branch::firstOrCreate([
            'name' => 'Mombasa Branch'
        ], [
            'location' => 'Mombasa Island',
            'description' => 'Coastal branch serving Mombasa region'
        ]);

        // Assign roles to existing users
        $admin = User::where('email', 'admin@morio-sacco.com')->first();
        if ($admin) {
            $admin->syncRoles(['Admin']);
        }

        $loanManager = User::where('email', 'loanmanager@morio-sacco.com')->first();
        if ($loanManager) {
            $loanManager->syncRoles(['Loan Manager']);
        }

        $frontOffice = User::where('email', 'frontoffice@morio-sacco.com')->first();
        if ($frontOffice) {
            $frontOffice->syncRoles(['Front Office']);
        }

        $member1 = User::where('email', 'member1@morio-sacco.com')->first();
        if ($member1) {
            $member1->syncRoles(['Member']);
        }

        $member2 = User::where('email', 'member2@morio-sacco.com')->first();
        if ($member2) {
            $member2->syncRoles(['Member']);
        }

        $this->command->info('Test users created successfully!');
        $this->command->info('================================');
        $this->command->info('Admin: admin@morio-sacco.com');
        $this->command->info('Loan Manager: loanmanager@morio-sacco.com');
        $this->command->info('Front Office: frontoffice@morio-sacco.com');
        $this->command->info('Member 1: member1@morio-sacco.com');
        $this->command->info('Member 2: member2@morio-sacco.com');
        $this->command->info('================================');
        $this->command->info('Password for all accounts: password');
        $this->command->info('================================');
        $this->command->info('Login at: http://127.0.0.1:8000/login');
    }
}
