<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class SystemConfigurationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $configurations = [
            [
                'key' => 'occupation_options',
                'value' => json_encode([
                    'Business Owner',
                    'Employee',
                    'Self-Employed',
                    'Farmer',
                    'Teacher',
                    'Doctor',
                    'Engineer',
                    'Lawyer',
                    'Accountant',
                    'Driver',
                    'Student',
                    'Retired',
                    'Other'
                ]),
                'type' => 'json',
                'category' => 'membership',
                'description' => 'Available occupation options for membership registration'
            ],
            [
                'key' => 'default_registration_fee',
                'value' => '1000',
                'type' => 'number',
                'category' => 'membership',
                'description' => 'Default membership registration fee'
            ],
            [
                'key' => 'allow_custom_occupation',
                'value' => 'true',
                'type' => 'boolean',
                'category' => 'membership',
                'description' => 'Allow members to enter custom occupation if not in list'
            ],
            [
                'key' => 'default_loan_interest_rate',
                'value' => '30',
                'type' => 'number',
                'category' => 'loans',
                'description' => 'Default annual interest rate for loans (percentage)'
            ]
        ];

        foreach ($configurations as $config) {
            \DB::table('system_configurations')->updateOrInsert(
                ['key' => $config['key']],
                $config
            );
        }

        $this->command->info('System configurations seeded successfully!');
    }
}
