<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class RoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create permissions
        $permissions = [
            // User management
            'view users',
            'create users',
            'edit users',
            'delete users',

            // Membership management
            'view memberships',
            'create memberships',
            'edit memberships',
            'delete memberships',
            'approve memberships',

            // Loan management
            'view loans',
            'create loans',
            'edit loans',
            'approve loans',
            'reject loans',

            // Savings management
            'view savings',
            'create savings',
            'edit savings',

            // Transaction management
            'view transactions',
            'create transactions',
            'process transactions',

            // Branch management
            'view branches',
            'create branches',
            'edit branches',
            'delete branches',

            // Share management
            'view shares',
            'create shares',
            'edit shares',

            // Dividend management
            'view dividends',
            'create dividends',
            'edit dividends',
            'approve dividends',

            // Reports
            'view reports',
            'export reports',

            // System settings
            'manage system settings',
            'manage mpesa settings',

            // Front office specific
            'process member applications',
            'handle member inquiries',
            'manage member documents',
        ];

        foreach ($permissions as $permission) {
            Permission::firstOrCreate(['name' => $permission]);
        }

        // Create roles and assign permissions

        // 1. Admin Role - Full access
        $admin = Role::firstOrCreate(['name' => 'Admin']);
        $admin->syncPermissions(Permission::all());

        // 2. Member Role - Limited access to own data
        $member = Role::firstOrCreate(['name' => 'Member']);
        $member->syncPermissions([
            'view memberships', // view own membership
            'view loans', // view own loans
            'view savings', // view own savings
            'view transactions', // view own transactions
            'view shares', // view own shares
            'view dividends', // view own dividends
        ]);

        // 3. Loan Manager Role - Loan and savings management
        $loanManager = Role::firstOrCreate(['name' => 'Loan Manager']);
        $loanManager->syncPermissions([
            'view users',
            'view memberships',
            'view loans',
            'create loans',
            'edit loans',
            'approve loans',
            'reject loans',
            'view savings',
            'create savings',
            'edit savings',
            'view transactions',
            'process transactions',
            'view reports',
            'export reports',
        ]);

        // 4. Front Office Role - Member services and administration
        $frontOffice = Role::firstOrCreate(['name' => 'Front Office']);
        $frontOffice->syncPermissions([
            'view users',
            'create users',
            'edit users',
            'view memberships',
            'create memberships',
            'edit memberships',
            'approve memberships',
            'view loans',
            'view savings',
            'view transactions',
            'create transactions',
            'view branches',
            'view shares',
            'view dividends',
            'view reports',
            'export reports',
            'process member applications',
            'handle member inquiries',
            'manage member documents',
        ]);

        $this->command->info('Roles and permissions created successfully!');
        $this->command->info('Admin: Full system access');
        $this->command->info('Member: Limited access to own data');
        $this->command->info('Loan Manager: Loan and savings management');
        $this->command->info('Front Office: Member services and administration');
    }
}
