<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Currency;

class CurrencySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $currencies = [
            [
                'name' => 'Kenyan Shilling',
                'code' => 'KES',
                'symbol' => 'KSh',
                'is_primary' => true,
                'is_active' => true,
                'sort_order' => 1,
            ],
            [
                'name' => 'US Dollar',
                'code' => 'USD',
                'symbol' => '$',
                'is_primary' => false,
                'is_active' => true,
                'sort_order' => 2,
            ],
            [
                'name' => 'Euro',
                'code' => 'EUR',
                'symbol' => '€',
                'is_primary' => false,
                'is_active' => true,
                'sort_order' => 3,
            ],
            [
                'name' => 'British Pound',
                'code' => 'GBP',
                'symbol' => '£',
                'is_primary' => false,
                'is_active' => true,
                'sort_order' => 4,
            ],
            [
                'name' => 'South African Rand',
                'code' => 'ZAR',
                'symbol' => 'R',
                'is_primary' => false,
                'is_active' => true,
                'sort_order' => 5,
            ],
            [
                'name' => 'Ugandan Shilling',
                'code' => 'UGX',
                'symbol' => 'UGX',
                'is_primary' => false,
                'is_active' => true,
                'sort_order' => 6,
            ],
            [
                'name' => 'Tanzanian Shilling',
                'code' => 'TZS',
                'symbol' => 'TSh',
                'is_primary' => false,
                'is_active' => true,
                'sort_order' => 7,
            ],
        ];

        foreach ($currencies as $currency) {
            Currency::create($currency);
        }
    }
}
