<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('money_market_accounts', function (Blueprint $table) {
            $table->enum('interest_type', ['simple', 'compound'])->default('simple')->after('interest_rate');
            $table->enum('compounding_frequency', ['monthly', 'quarterly', 'annually'])->default('annually')->after('interest_type');
            $table->timestamp('last_interest_update')->nullable()->after('total_amount');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('money_market_accounts', function (Blueprint $table) {
            $table->dropColumn(['interest_type', 'compounding_frequency', 'last_interest_update']);
        });
    }
};
