<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('loan_guarantors', function (Blueprint $table) {
            $table->dropForeign(['loan_guarantee_id']);
            $table->dropColumn('loan_guarantee_id');
            $table->unsignedBigInteger('loan_id')->after('id');
            $table->foreign('loan_id')->references('id')->on('loans')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('loan_guarantors', function (Blueprint $table) {
            $table->dropForeign(['loan_id']);
            $table->dropColumn('loan_id');
            $table->unsignedBigInteger('loan_guarantee_id')->after('id');
            $table->foreign('loan_guarantee_id')->references('id')->on('loan_guarantees')->onDelete('cascade');
        });
    }
};
