<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('loan_salary_guarantees', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('loan_guarantee_id');
            $table->string('employer_name');
            $table->string('employer_address');
            $table->string('employer_phone');
            $table->string('employee_position');
            $table->decimal('monthly_salary', 15, 2);
            $table->date('employment_start_date');
            $table->string('employment_letter_path')->nullable(); // Path to employment letter
            $table->string('confirmation_letter_path')->nullable(); // Path to employer's confirmation letter
            $table->json('payslip_paths')->nullable(); // Array of paths to 2 months payslips
            $table->enum('status', ['pending', 'approved', 'rejected'])->default('pending');
            $table->text('verification_notes')->nullable();
            $table->timestamp('approved_at')->nullable();
            $table->unsignedBigInteger('approved_by')->nullable();
            $table->foreign('loan_guarantee_id')->references('id')->on('loan_guarantees')->onDelete('cascade');
            $table->foreign('approved_by')->references('id')->on('users');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('loan_salary_guarantees');
    }
};
