<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('loan_collaterals', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('loan_guarantee_id');
            $table->string('item_type'); // e.g., 'vehicle', 'land', 'house', 'machinery', etc.
            $table->string('item_description');
            $table->decimal('estimated_value', 15, 2);
            $table->string('ownership_document_type'); // e.g., 'title_deed', 'log_book', 'receipt', etc.
            $table->string('ownership_document_number');
            $table->date('ownership_document_date');
            $table->text('ownership_details'); // Additional ownership information
            $table->string('document_file_path')->nullable(); // Path to uploaded document
            $table->enum('status', ['pending', 'approved', 'rejected'])->default('pending');
            $table->text('valuation_notes')->nullable();
            $table->timestamp('approved_at')->nullable();
            $table->unsignedBigInteger('approved_by')->nullable();
            $table->foreign('loan_guarantee_id')->references('id')->on('loan_guarantees')->onDelete('cascade');
            $table->foreign('approved_by')->references('id')->on('users');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('loan_collaterals');
    }
};
