<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('transactions', function (Blueprint $table) {
            // Update existing type enum to include more transaction types
            $table->enum('type', [
                'mpesa_deposit',
                'mpesa_withdrawal',
                'account_transfer',
                'loan_disbursement',
                'loan_repayment',
                'savings_deposit',
                'savings_withdrawal',
                'registration_fee',
                'share_purchase',
                'dividend_payment',
                'interest_payment',
                'fee_payment',
                'other'
            ])->default('other')->change();

            // Add new fields for comprehensive transaction tracking
            $table->string('reference_number')->nullable()->after('mpesa_transaction_id');
            $table->unsignedBigInteger('from_user_id')->nullable()->after('user_id');
            $table->unsignedBigInteger('to_user_id')->nullable()->after('from_user_id');
            $table->unsignedBigInteger('from_account_id')->nullable()->after('to_user_id');
            $table->unsignedBigInteger('to_account_id')->nullable()->after('from_account_id');
            $table->string('payment_method')->nullable()->after('to_account_id');
            $table->string('transaction_category')->nullable()->after('payment_method');
            $table->decimal('fee_amount', 10, 2)->default(0)->after('amount');
            $table->decimal('tax_amount', 10, 2)->default(0)->after('fee_amount');
            $table->string('currency', 3)->default('KES')->after('tax_amount');
            $table->text('description')->nullable()->after('notes');
            $table->json('metadata')->nullable()->after('description');
            $table->timestamp('processed_at')->nullable()->after('mpesa_response');

            // Add foreign key constraints
            $table->foreign('from_user_id')->references('id')->on('users')->onDelete('set null');
            $table->foreign('to_user_id')->references('id')->on('users')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('transactions', function (Blueprint $table) {
            //
        });
    }
};
