<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('memberships', function (Blueprint $table) {
            $table->decimal('registration_fee', 10, 2)->default(500.00)->after('savings_balance');
            $table->string('passport_photo')->nullable()->after('registration_fee');
            $table->enum('registration_fee_status', ['pending', 'paid', 'waived'])->default('pending')->after('passport_photo');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('memberships', function (Blueprint $table) {
            $table->dropColumn(['registration_fee', 'passport_photo', 'registration_fee_status']);
        });
    }
};
