<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\View;
use App\Models\SystemSetting;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        // Dynamically set the adminlte footer from system settings
        View::composer('adminlte::page', function ($view) {
            $footer = SystemSetting::get('system_footer', 'Powered by <a href="https://zillahtechnologies.co.ke" target="_blank">Zillah Technologies LTD</a> | Morio Sacco');
            config(['adminlte.footer' => $footer]);
        });

        // Add footer to auth pages
        View::composer('adminlte::auth.auth-page', function ($view) {
            $view->with('system_footer', SystemSetting::get('system_footer', 'Powered by <a href="https://zillahtechnologies.co.ke" target="_blank">Zillah Technologies LTD</a> | Morio Sacco'));
        });
    }
}
