<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Share extends Model
{
    protected $fillable = [
        'user_id',
        'number_of_shares',
        'share_value',
        'total_value',
        'purchase_date',
        'notes',
    ];

    protected $casts = [
        'number_of_shares' => 'integer',
        'share_value' => 'decimal:2',
        'total_value' => 'decimal:2',
        'purchase_date' => 'date',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function getFormattedTotalValueAttribute()
    {
        return 'KES ' . number_format($this->total_value, 2);
    }

    public function getFormattedShareValueAttribute()
    {
        return 'KES ' . number_format($this->share_value, 2);
    }

    public function getPurchaseDateFormattedAttribute()
    {
        return $this->purchase_date ? $this->purchase_date->format('M d, Y') : 'N/A';
    }
}
