<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Saving extends Model
{
    protected $fillable = [
        'user_id',
        'amount',
        'type',
        'status',
        'maturity_date',
        'notes',
    ];

    protected $casts = [
        'amount' => 'decimal:2',
        'maturity_date' => 'date',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function getTypeLabelAttribute()
    {
        return match($this->type) {
            'regular' => 'Regular Savings',
            'fixed' => 'Fixed Deposit',
            'emergency' => 'Emergency Fund',
            default => ucfirst($this->type)
        };
    }

    public function getStatusLabelAttribute()
    {
        return match($this->status) {
            'active' => 'Active',
            'withdrawn' => 'Withdrawn',
            'matured' => 'Matured',
            default => ucfirst($this->status)
        };
    }

    public function getStatusColorAttribute()
    {
        return match($this->status) {
            'active' => 'success',
            'withdrawn' => 'warning',
            'matured' => 'info',
            default => 'secondary'
        };
    }

    public function getTypeColorAttribute()
    {
        return match($this->type) {
            'regular' => 'primary',
            'fixed' => 'info',
            'emergency' => 'danger',
            default => 'secondary'
        };
    }

    public function transactions()
    {
        return $this->hasMany(SavingsTransaction::class)->orderBy('transaction_date', 'desc');
    }

    public function getCurrentBalanceAttribute()
    {
        // Calculate current balance from transactions
        $deposits = $this->transactions()->where('type', 'deposit')->sum('amount');
        $withdrawals = $this->transactions()->where('type', 'withdrawal')->sum('amount');
        return $deposits - $withdrawals;
    }
}
