<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Membership extends Model
{
    protected $fillable = [
        'user_id',
        'gender',
        'occupation',
        'membership_number',
        'joining_date',
        'status',
        'share_capital',
        'savings_balance',
        'registration_fee',
        'passport_photo',
        'registration_fee_status',
        'notes',
    ];

    protected $casts = [
        'joining_date' => 'date',
        'share_capital' => 'decimal:2',
        'savings_balance' => 'decimal:2',
        'registration_fee' => 'decimal:2',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
