<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class LoanSalaryGuarantee extends Model
{
    protected $fillable = [
        'loan_guarantee_id',
        'employer_name',
        'employer_address',
        'employer_phone',
        'employee_position',
        'monthly_salary',
        'employment_start_date',
        'employment_letter_path',
        'confirmation_letter_path',
        'payslip_paths',
        'status',
        'verification_notes',
        'approved_at',
        'approved_by',
    ];

    protected $casts = [
        'monthly_salary' => 'decimal:2',
        'employment_start_date' => 'date',
        'payslip_paths' => 'array',
        'approved_at' => 'datetime',
    ];

    public function loanGuarantee(): BelongsTo
    {
        return $this->belongsTo(LoanGuarantee::class);
    }

    public function approvedBy(): BelongsTo
    {
        return $this->belongsTo(User::class, 'approved_by');
    }

    public function getStatusColorAttribute()
    {
        return match($this->status) {
            'approved' => 'success',
            'pending' => 'warning',
            'rejected' => 'danger',
            default => 'secondary'
        };
    }

    public function getEmploymentDurationAttribute()
    {
        if ($this->employment_start_date) {
            return $this->employment_start_date->diffInMonths(now());
        }
        return 0;
    }

    public function hasRequiredDocuments()
    {
        return !empty($this->employment_letter_path) &&
               !empty($this->confirmation_letter_path) &&
               !empty($this->payslip_paths) &&
               count($this->payslip_paths) >= 2;
    }
}
