<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\ValidationException;

class LoginController extends Controller
{

    public function showLoginForm()
    {
        return view('auth.login');
    }

    public function login(Request $request)
    {
        $request->validate([
            'email' => 'required|email',
            'password' => 'required',
        ]);

        if (Auth::attempt($request->only('email', 'password'), $request->filled('remember'))) {
            $request->session()->regenerate();
            return redirect()->intended('/home');
        }

        throw ValidationException::withMessages([
            'email' => [trans('auth.failed')],
        ]);
    }

    public function logout(Request $request)
    {
        try {
            // Set a shorter timeout for logout operations
            set_time_limit(10);

            Auth::logout();
            $request->session()->invalidate();
            $request->session()->regenerateToken();

            return redirect('/');
        } catch (\Exception $e) {
            // If database operations fail, still logout from auth but skip session cleanup
            Auth::logout();

            // Log the error for debugging
            \Log::warning('Logout database error: ' . $e->getMessage());

            // Force redirect even if session cleanup fails
            return redirect('/')->with('warning', 'You have been logged out, but there was an issue clearing your session.');
        }
    }
}
