<?php

namespace App\Exports;

use App\Models\Transaction;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class TransactionsExport implements FromQuery, WithHeadings, WithMapping, ShouldAutoSize
{
    protected $filters;

    public function __construct(array $filters = [])
    {
        $this->filters = $filters;
    }

    public function query()
    {
        $query = Transaction::with(['user', 'fromUser', 'toUser']);

        // Apply same filters as controller
        if (!empty($this->filters['type'])) {
            $query->where('type', $this->filters['type']);
        }

        if (!empty($this->filters['status'])) {
            $query->where('status', $this->filters['status']);
        }

        if (!empty($this->filters['user_id'])) {
            $query->where('user_id', $this->filters['user_id']);
        }

        if (!empty($this->filters['date_from'])) {
            $query->whereDate('created_at', '>=', $this->filters['date_from']);
        }

        if (!empty($this->filters['date_to'])) {
            $query->whereDate('created_at', '<=', $this->filters['date_to']);
        }

        return $query->orderBy('created_at', 'desc');
    }

    public function headings(): array
    {
        return [
            'Transaction ID',
            'Reference Number',
            'Date',
            'Type',
            'Member',
            'Amount',
            'Fee',
            'Tax',
            'Total',
            'Currency',
            'From User',
            'To User',
            'Payment Method',
            'M-Pesa ID',
            'Status',
            'Description',
            'Notes',
            'Processed At',
        ];
    }

    public function map($transaction): array
    {
        return [
            $transaction->id,
            $transaction->reference_number,
            $transaction->created_at->format('Y-m-d H:i:s'),
            $transaction->type_label,
            $transaction->user->full_name ?? 'N/A',
            $transaction->amount,
            $transaction->fee_amount,
            $transaction->tax_amount,
            $transaction->total_amount,
            $transaction->currency,
            $transaction->fromUser->full_name ?? 'N/A',
            $transaction->toUser->full_name ?? 'N/A',
            $transaction->payment_method,
            $transaction->mpesa_transaction_id,
            ucfirst($transaction->status),
            $transaction->description,
            $transaction->notes,
            $transaction->processed_at?->format('Y-m-d H:i:s'),
        ];
    }
}
