<?php

namespace App\Exports;

use App\Models\MoneyMarketAccount;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class MoneyMarketAccountsExport implements FromCollection, WithHeadings, WithMapping
{
    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        return MoneyMarketAccount::with('membership.user')->get();
    }

    /**
     * @return array
     */
    public function headings(): array
    {
        return [
            'ID',
            'Account Number',
            'Member Name',
            'Membership Number',
            'Principal Amount',
            'Interest Rate (%)',
            'Interest Type',
            'Compounding Frequency',
            'Term (Months)',
            'Interest Earned',
            'Total Amount',
            'Start Date',
            'Maturity Date',
            'Status',
            'Currency',
            'Created Date',
        ];
    }

    /**
     * @param mixed $account
     * @return array
     */
    public function map($account): array
    {
        return [
            $account->id,
            $account->account_number,
            $account->membership->user->full_name ?? 'N/A',
            $account->membership->membership_number ?? 'N/A',
            $account->principal_amount,
            $account->interest_rate,
            ucfirst($account->interest_type),
            $account->compounding_frequency ? ucfirst($account->compounding_frequency) : 'N/A',
            $account->term_months,
            $account->interest_earned,
            $account->total_amount,
            $account->start_date->format('Y-m-d'),
            $account->maturity_date->format('Y-m-d'),
            ucfirst($account->status),
            $account->currency_code,
            $account->created_at->format('Y-m-d H:i:s'),
        ];
    }
}
