<?php

namespace App\Exports;

use App\Models\Loan;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class LoansExport implements FromQuery, WithHeadings, WithMapping, ShouldAutoSize
{
    protected $filters;

    public function __construct(array $filters = [])
    {
        $this->filters = $filters;
    }

    public function query()
    {
        $query = Loan::with(['user', 'user.branch']);

        // Apply same filters as controller
        if (!empty($this->filters['status'])) {
            $query->where('status', $this->filters['status']);
        }

        if (!empty($this->filters['user_id'])) {
            $query->where('user_id', $this->filters['user_id']);
        }

        return $query->orderBy('created_at', 'desc');
    }

    public function headings(): array
    {
        return [
            'Loan ID',
            'Member Name',
            'ID Number',
            'Phone Number',
            'Email',
            'Branch',
            'Amount',
            'Interest Rate (%)',
            'Term (Months)',
            'Total Amount',
            'Monthly Payment',
            'Status',
            'Approved Date',
            'Maturity Date',
            'Application Date',
            'Notes',
        ];
    }

    public function map($loan): array
    {
        return [
            $loan->id,
            $loan->user->full_name ?? 'N/A',
            $loan->user->id_number ?? 'N/A',
            $loan->user->phone_number ?? 'N/A',
            $loan->user->email ?? 'N/A',
            $loan->user->branch->name ?? 'N/A',
            $loan->amount,
            $loan->interest_rate,
            $loan->term_months,
            $loan->total_amount,
            $loan->monthly_payment,
            ucfirst($loan->status),
            $loan->approved_at?->format('Y-m-d H:i:s'),
            $loan->maturity_date?->format('Y-m-d'),
            $loan->created_at->format('Y-m-d H:i:s'),
            $loan->notes,
        ];
    }
}
