<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithTitle;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class LoanPerformanceReportExport implements FromArray, WithHeadings, WithTitle, ShouldAutoSize
{
    protected $data;

    public function __construct($data)
    {
        $this->data = $data;
    }

    public function array(): array
    {
        $rows = [];

        // By Status
        $rows[] = ['LOANS BY STATUS'];
        $rows[] = ['Status', 'Count', 'Total Amount', 'Average Amount'];
        foreach ($this->data['by_status'] as $status => $stats) {
            $rows[] = [$status, $stats['count'], $stats['total_amount'], $stats['average_amount']];
        }
        $rows[] = [''];

        // By Term
        $rows[] = ['LOANS BY TERM'];
        $rows[] = ['Term (Months)', 'Count', 'Total Amount'];
        foreach ($this->data['by_term'] as $term => $stats) {
            $rows[] = [$term, $stats['count'], $stats['total_amount']];
        }
        $rows[] = [''];

        // Repayment Performance
        $rows[] = ['REPAYMENT PERFORMANCE'];
        $rows[] = ['Metric', 'Amount'];
        $rows[] = ['Total Disbursed', $this->data['repayment_performance']['total_disbursed']];
        $rows[] = ['Total Repaid', $this->data['repayment_performance']['total_repaid']];
        $rows[] = ['Outstanding Balance', $this->data['repayment_performance']['outstanding_balance']];
        $rows[] = [''];

        // Default Risk
        $rows[] = ['DEFAULT RISK ANALYSIS'];
        $rows[] = ['Risk Factor', 'Count/Value'];
        $rows[] = ['Overdue Loans', $this->data['default_risk']['overdue_loans']];
        $rows[] = ['High Value Loans', $this->data['default_risk']['high_value_loans']];

        return $rows;
    }

    public function headings(): array
    {
        return [
            'Loan Performance Report - ' . date('M Y')
        ];
    }

    public function title(): string
    {
        return 'Loan Performance';
    }
}
