<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithTitle;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class FinancialReportExport implements FromArray, WithHeadings, WithTitle, ShouldAutoSize
{
    protected $data;

    public function __construct($data)
    {
        $this->data = $data;
    }

    public function array(): array
    {
        $rows = [];

        // Income Section
        $rows[] = ['INCOME'];
        $rows[] = ['Category', 'Amount (KES)'];
        $rows[] = ['Savings Deposits', $this->data['income']['savings_deposits']];
        $rows[] = ['Loan Repayments', $this->data['income']['loan_repayments']];
        $rows[] = ['Registration Fees', $this->data['income']['registration_fees']];
        $rows[] = ['Share Purchases', $this->data['income']['share_purchases']];
        $rows[] = ['Total Income', array_sum($this->data['income'])];
        $rows[] = [''];

        // Expenses Section
        $rows[] = ['EXPENSES'];
        $rows[] = ['Category', 'Amount (KES)'];
        $rows[] = ['Loan Disbursements', $this->data['expenses']['loan_disbursements']];
        $rows[] = ['Savings Withdrawals', $this->data['expenses']['savings_withdrawals']];
        $rows[] = ['Dividend Payments', $this->data['expenses']['dividend_payments']];
        $rows[] = ['Fee Payments', $this->data['expenses']['fee_payments']];
        $rows[] = ['Total Expenses', array_sum($this->data['expenses'])];
        $rows[] = [''];

        // Net Income
        $netIncome = array_sum($this->data['income']) - array_sum($this->data['expenses']);
        $rows[] = ['NET INCOME', $netIncome];
        $rows[] = [''];

        // Balances Section
        $rows[] = ['BALANCES'];
        $rows[] = ['Category', 'Amount (KES)'];
        $rows[] = ['Total Savings', $this->data['balances']['total_savings']];
        $rows[] = ['Total Loans Outstanding', $this->data['balances']['total_loans_outstanding']];
        $rows[] = ['Total Shares', $this->data['balances']['total_shares']];
        $rows[] = [''];

        // Period Summary
        $rows[] = ['PERIOD SUMMARY'];
        $rows[] = ['Metric', 'Value'];
        $rows[] = ['Total Transactions', $this->data['period_summary']['total_transactions']];
        $rows[] = ['Active Loans', $this->data['period_summary']['active_loans']];
        $rows[] = ['Active Savings Accounts', $this->data['period_summary']['active_savings_accounts']];

        return $rows;
    }

    public function headings(): array
    {
        return [
            'Financial Summary Report - ' . date('M Y')
        ];
    }

    public function title(): string
    {
        return 'Financial Summary';
    }
}
