<?php

namespace App\Exports;

use App\Models\Branch;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class BranchesExport implements FromCollection, WithHeadings, WithMapping
{
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        return Branch::withCount('users')->get();
    }

    /**
     * @return array
     */
    public function headings(): array
    {
        return [
            'ID',
            'Branch Name',
            'Location',
            'Description',
            'Total Members',
            'Created Date',
        ];
    }

    /**
     * @param mixed $branch
     * @return array
     */
    public function map($branch): array
    {
        return [
            $branch->id,
            $branch->name,
            $branch->location,
            $branch->description,
            $branch->users_count,
            $branch->created_at->format('Y-m-d'),
        ];
    }
}
